### Expert Knowledge for Sider Task

* **General structure–toxicity principles**
  Many adverse drug reactions arise from a small set of structure–toxicity mechanisms, whose approximate potency follows:
  **covalent binding to biomolecules > membrane disruption > enzyme inhibition > receptor antagonism > ion-channel blockade**.
  Structural motifs that enable these mechanisms (e.g., electrophilic “warheads”, large hydrophobic/aromatic systems) are often associated with higher risk of system-level side effects across multiple organs.

* **Electrophilic “toxicophores” and reactive metabolites**
  Acute and chronic toxicities frequently originate from electrophile–nucleophile chemistry, either directly or via metabolic activation. Functionality with low LUMO energies tends to be more reactive toward nucleophilic sites (e.g., cysteine, lysine, DNA bases). Important electrophilic motifs include:

  * **Aldehydes (–CHO)**
  * **α,β-unsaturated carbonyls** (Michael acceptors)
  * **Epoxides and aziridines**
  * **Haloalkyl groups**
  * **Aromatic amines and their oxidized metabolites**
    These groups can form covalent adducts with proteins or DNA, leading to hepatobiliary toxicity, hematologic disorders, immune reactions, carcinogenicity, and various organ damages, depending on where activation and binding occur.

* **Role of metabolic activation (especially in liver)**
  Many side effects manifest in organs with high metabolic capacity, particularly the **liver (hepatobiliary disorders)**:

  * CYP450 enzymes can convert relatively inert aromatic or heterocyclic structures (e.g., polycyclic aromatics, some heterocycles) into **reactive epoxides or quinone-like species**.
  * These metabolites can bind covalently to hepatic proteins or DNA, provoking hepatotoxicity, immune-mediated liver injury, or long-term neoplastic effects.
  * Structural patterns prone to such activation include extended conjugated π-systems (e.g., PAHs) and certain electron-rich heterocycles.

* **Hydrophobicity, bioaccumulation, and chronic side effects**
  High hydrophobicity (often **logP > 5**) and chemically stable scaffolds favor:

  * **Accumulation in lipid-rich tissues** (adipose tissue, nervous system, endocrine organs),
  * **Long biological half-lives** and persistent exposure,
  * Increased risk of **chronic toxicity**, including metabolic and nutrition disorders, endocrine disruption, and nervous system effects.
    Persistent organic structures (e.g., heavily halogenated aromatics, perfluorinated moieties) are especially prone to such behavior.

* **Endocrine disruption and hormone mimicry**
  Some side effects are driven by **structural mimicry of endogenous hormones**, contributing to:

  * **Endocrine disorders**,
  * **Reproductive system and breast disorders**,
  * **Pregnancy, puerperium and perinatal conditions**.
    Key structural features include:
  * Aromatic or polycyclic cores with **phenolic OH** groups at distances similar to those in natural hormones (e.g., estrogens),
  * Flexible hydrophobic side-chains that reproduce the 3D pharmacophore of steroidal or peptide hormones.
    Molecules with such hormone-like motifs can bind to nuclear receptors (e.g., estrogen, androgen, thyroid receptors) and perturb endocrine and reproductive homeostasis.

* **DNA interaction, carcinogenicity, and neoplasms**
  Structural motifs that interact strongly with DNA are linked to:

  * **Neoplasms (benign, malignant, and unspecified)**,
  * **Genetic and congenital disorders**,
  * **Injury/poisoning and long-term carcinogenic complications**.
    Relevant mechanisms and scaffolds include:
  * **DNA alkylators** (e.g., nitrogen mustards, strong electrophiles) forming covalent adducts or cross-links,
  * **Polycyclic aromatic hydrocarbons (PAHs)** and planar heteroaromatics that intercalate between base pairs,
  * **Metabolically activated “bay-region” epoxides**, whose geometry and electron distribution favor persistent DNA adduct formation.

* **Heterocycles and organ-specific toxicity patterns**
  Heterocycles contribute importantly to both efficacy and toxicity:

  * Electron-rich five-membered rings (e.g., **furan**, **pyrrole**) can be oxidized to reactive intermediates, often associated with **hepatotoxicity**, **hematologic issues**, or **immune-system disorders**.
  * Nitrogen heterocycles (e.g., pyridine, imidazole, pyrimidine) can coordinate metal ions or interfere with enzyme cofactors, which may contribute to **blood and lymphatic system disorders**, **endocrine** or **nervous system** side effects depending on the target.

* **Hydrophobic/aromatic scaffolds and CNS / psychiatric / nervous system effects**
  Large aromatic/heteroaromatic systems with moderate to high lipophilicity:

  * Tend to cross the BBB more readily and accumulate in neural tissue,
  * Can interact with neurotransmitter receptors, ion channels, and transporters.
    Such molecules are more likely to cause **nervous system disorders** (e.g., seizures, movement disorders) and **psychiatric disorders** (e.g., mood, cognition, or behavior changes), especially if their pharmacophore resembles that of endogenous neurotransmitters or CNS-active drugs.

* **Immune system, skin, and hypersensitivity reactions**
  Immune-mediated side effects (e.g., **immune system disorders**, **skin and subcutaneous tissue disorders**, some **respiratory** or **vascular** reactions) often arise when:

  * Reactive metabolites form **hapten–protein conjugates**, converting self-proteins into neoantigens,
  * Certain aromatic amines, sulfonamides, and reactive heterocycles are metabolized into electrophiles that trigger **idiosyncratic hypersensitivity** reactions.
    These mechanisms link structural “alert” motifs (e.g., anilines, sulfonyl groups adjacent to aromatic systems, nitroso/azo groups) to immunologic adverse effects.

* **Renal and urinary toxicity**
  The kidney is a major organ for excretion and concentration of xenobiotics:

  * Highly polar or partially ionized metabolites can accumulate in renal tubules,
  * Reactive electrophiles formed upstream (e.g., in liver) may be delivered to the kidney and cause **renal and urinary disorders** through covalent binding to tubular proteins or oxidative stress.
    Structures that are both metabolically activated and efficiently excreted via the kidney have a higher risk of nephrotoxicity.

* **High-level guidance for Sider task decisions (“True/False”)**
  When reasoning whether a given molecule is likely associated with a specific Sider side-effect class, helpful structural cues include:

  1. **Presence of electrophilic or metabolically activatable groups** (aldehydes, Michael acceptors, epoxides, aromatic amines, electron-rich heterocycles) suggesting covalent binding or reactive metabolites → often linked to **hepatobiliary**, **blood**, **immune**, **skin**, **neoplastic**, or **procedural complication**-type side effects.
  2. **Degree of hydrophobicity and aromaticity** indicating potential for **bioaccumulation**, **endocrine disruption**, or **CNS involvement**, thus raising risk for **metabolism/nutrition**, **endocrine**, **reproductive**, **nervous system**, and **psychiatric** disorders.
  3. **Similarity to endogenous hormones or neurotransmitters** (phenolic steroids, catecholamine-like scaffolds, indole/tryptamine-like cores) suggesting endocrine or CNS-related side effects.
  4. **Structural alerts for DNA interaction and mutagenicity** (planar polyaromatics, strong DNA alkylators) implying potential **neoplasms**, **congenital/genetic** disorders, and long-term carcinogenic events.

  In a simplified classification setting, molecules carrying such structural alerts or combinations thereof can be considered **more likely “True”** for one or more side-effect categories, whereas the absence of these features (and a more “benign” physicochemical profile) leans toward **“False”** for those toxicity labels.
